/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.runtime.mapui;

import filenet.vw.api.VWMapNode;
import filenet.vw.api.VWRouteDefinition;
import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.runtime.VWTrkDataModel;
import filenet.vw.toolkit.runtime.VWTrkMap;
import filenet.vw.toolkit.runtime.VWTrkRoute;
import filenet.vw.toolkit.runtime.VWTrkStep;
import filenet.vw.toolkit.runtime.VWTrkStepOccurrence;
import filenet.vw.toolkit.runtime.mapui.IVWTrackerStepUI;
import filenet.vw.toolkit.runtime.mapui.VWTrackerCallStepUI;
import filenet.vw.toolkit.runtime.mapui.VWTrackerComponentStepUI;
import filenet.vw.toolkit.runtime.mapui.VWTrackerGeneralStepUI;
import filenet.vw.toolkit.runtime.mapui.VWTrackerLaunchStepUI;
import filenet.vw.toolkit.runtime.mapui.VWTrackerMap;
import filenet.vw.toolkit.runtime.mapui.VWTrackerRouteUI;
import filenet.vw.toolkit.runtime.mapui.VWTrackerSystemStepUI;
import filenet.vw.toolkit.runtime.mapui.VWTrackerWorkflowPane;
import filenet.vw.toolkit.runtime.mapui.resources.VWResource;
import filenet.vw.toolkit.utils.event.IVWPropertyChangeSource;
import filenet.vw.toolkit.utils.event.VWPropertyChangeEvent;
import filenet.vw.toolkit.utils.mapui.IVWSelectWorkflowItem;
import filenet.vw.toolkit.utils.mapui.VWBaseRouteUI;
import filenet.vw.toolkit.utils.mapui.VWBaseStepUI;
import filenet.vw.toolkit.utils.mapui.VWBaseWorkflowMapPane;
import filenet.vw.toolkit.utils.mapui.VWMap;
import filenet.vw.toolkit.utils.mapui.VWMapNodeUIToolkit;
import filenet.vw.toolkit.utils.mapui.VWStepRouteColors;
import java.awt.Component;
import java.awt.Frame;
import java.awt.ItemSelectable;
import java.awt.event.ItemEvent;
import java.awt.event.MouseEvent;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JPopupMenu;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class VWTrackerWorkflowMapPane
extends VWBaseWorkflowMapPane {
    private VWTrkDataModel m_trackerDataModel = null;
    private VWTrkMap m_mapData = null;
    private Frame m_parentFrame = null;
    private VWPropertyChangeEvent m_propertyChangeEvent = null;
    private VWMapNodeUIToolkit m_vwMapNodeUIToolkit = null;
    protected Vector m_changeListeners = new Vector();
    private JPopupMenu m_popup = null;
    private Hashtable m_stepDataToUI = null;
    private Hashtable m_routeDataToUI = null;

    public VWTrackerWorkflowMapPane(VWTrackerWorkflowPane workflowPane) {
        super(workflowPane);
        try {
            if (workflowPane != null) {
                this.m_parentFrame = workflowPane.getParentFrame();
                this.m_vwMapNodeUIToolkit = new VWMapNodeUIToolkit(workflowPane.getSessionInfo().getExternalClassLoader(), workflowPane.getMapAttributes());
            }
        }
        catch (Throwable ex) {
            VWDebug.logException(new Exception(ex));
        }
    }

    public void setMapDefinition(VWMap map) {
        try {
            this.m_steps = new Vector();
            this.m_routes = new Vector();
            if (map != null && map instanceof VWTrackerMap) {
                this.m_map = map;
                this.m_mapData = ((VWTrackerMap)map).getTrackerMap();
                this.m_trackerDataModel = this.m_mapData.getDataModel();
                if (this.m_mapData == null) {
                    VWDebug.logWarning(VWResource.s_nullWorkflowDefinition);
                } else {
                    Vector stepCollection;
                    VWStepRouteColors stepRouteColors = null;
                    if (this.m_workflowPane != null && this.m_workflowPane instanceof VWTrackerWorkflowPane) {
                        stepRouteColors = ((VWTrackerWorkflowPane)this.m_workflowPane).getStepRouteColors();
                    }
                    if ((stepCollection = this.m_mapData.getStepCollection()) != null) {
                        int index;
                        int initialStepId = -1;
                        if (this.m_mapData.getMapId() == this.m_trackerDataModel.getInitialMapId()) {
                            initialStepId = this.m_trackerDataModel.getInitialStepId();
                        }
                        Vector routeCollection = this.m_mapData.getRouteCollection();
                        this.m_stepDataToUI = new Hashtable(stepCollection.size());
                        this.m_routeDataToUI = new Hashtable(routeCollection.size());
                        for (index = 0; index < stepCollection.size(); ++index) {
                            VWBaseStepUI step = null;
                            VWTrkStep stepData = (VWTrkStep)stepCollection.elementAt(index);
                            VWMapNode mapNode = stepData.getMapNode();
                            if (this.m_mapData.isLaunchStep(mapNode)) {
                                step = new VWTrackerLaunchStepUI(this.m_parentFrame, stepData, this.m_vwMapNodeUIToolkit);
                            } else if (stepData.isQueueStep() || stepData.isUserStep() || stepData.isDummyStep()) {
                                step = new VWTrackerGeneralStepUI(this.m_parentFrame, stepData, stepData.isStartStep(), this.m_vwMapNodeUIToolkit);
                            } else if (stepData.isCallStep()) {
                                step = new VWTrackerCallStepUI(this.m_parentFrame, stepData, stepData.isStartStep(), this.m_vwMapNodeUIToolkit);
                            } else if (stepData.isSystemStep()) {
                                step = new VWTrackerSystemStepUI(this.m_parentFrame, stepData, stepData.isStartStep(), this.m_vwMapNodeUIToolkit);
                            } else if (stepData.isComponentStep()) {
                                step = new VWTrackerComponentStepUI(this.m_parentFrame, stepData, stepData.isStartStep(), this.m_vwMapNodeUIToolkit);
                            }
                            if (step != null && mapNode != null && initialStepId == mapNode.getStepId()) {
                                step.setFocus(true);
                                step.setSelect(true);
                            }
                            this.m_steps.addElement(step);
                            this.m_stepDataToUI.put(stepData, step);
                            step.addFocusListener(this);
                        }
                        for (index = 0; index < routeCollection.size(); ++index) {
                            VWTrackerRouteUI route = null;
                            VWBaseStepUI prevStep = null;
                            VWBaseStepUI nextStep = null;
                            VWTrkStep step = null;
                            VWTrkRoute routeData = (VWTrkRoute)routeCollection.elementAt(index);
                            step = routeData.getPreviousStep();
                            if (step != null) {
                                prevStep = (VWBaseStepUI)this.m_stepDataToUI.get(step);
                            }
                            if ((step = routeData.getNextStep()) != null) {
                                nextStep = (VWBaseStepUI)this.m_stepDataToUI.get(step);
                            }
                            if (nextStep == null || (route = nextStep.hasARouteToStep(prevStep) ? new VWTrackerRouteUI(routeData, prevStep, nextStep, false, 2, stepRouteColors, this.m_workflowPane.getMapAttributes()) : new VWTrackerRouteUI(routeData, prevStep, nextStep, false, 1, stepRouteColors, this.m_workflowPane.getMapAttributes())) == null) continue;
                            route.addFocusListener(this);
                            prevStep.addNextRoute(route, nextStep);
                            nextStep.addPrevRoute(route, prevStep);
                            this.repaint(route.getBounds());
                            this.m_routes.addElement(route);
                            this.m_routeDataToUI.put(routeData, route);
                        }
                    } else {
                        VWDebug.logError(VWResource.s_noStepsOnMap);
                    }
                }
                this.recalculateBounds(0);
                this.repaint();
            }
        }
        catch (Throwable ex) {
            VWDebug.logException(new Exception(ex));
        }
    }

    protected VWTrackerRouteUI findRoute(int routeId) {
        try {
            for (int index = 0; index < this.m_routes.size(); ++index) {
                VWTrackerRouteUI route = (VWTrackerRouteUI)this.m_routes.elementAt(index);
                if (route.getId() != routeId) continue;
                return route;
            }
        }
        catch (Throwable ex) {
            VWDebug.logException(new Exception(ex));
        }
        return null;
    }

    protected VWTrackerRouteUI findRoute(VWTrkRoute route) {
        return (VWTrackerRouteUI)this.m_routeDataToUI.get(route);
    }

    public VWBaseRouteUI findRoute(VWRouteDefinition routeDefinition) {
        return super.findRoute(routeDefinition);
    }

    protected IVWTrackerStepUI findStep(int stepId) {
        try {
            Object obj = null;
            for (int index = 0; index < this.m_steps.size(); ++index) {
                IVWTrackerStepUI step;
                obj = this.m_steps.elementAt(index);
                if (!(obj instanceof IVWTrackerStepUI) || (step = (IVWTrackerStepUI)obj).getId() != stepId) continue;
                return step;
            }
        }
        catch (Throwable ex) {
            VWDebug.logException(new Exception(ex));
        }
        return null;
    }

    public VWBaseStepUI findStep(VWMapNode mapNode) {
        return super.findStep(mapNode);
    }

    protected IVWTrackerStepUI findStep(VWTrkStep step) {
        try {
            if (step == null) {
                System.out.println("findStep(step) - step is null");
                return null;
            }
            if (this.m_stepDataToUI == null) {
                System.out.println("findStep(step) - m_stepDataToUI is null");
                return null;
            }
            return (IVWTrackerStepUI)this.m_stepDataToUI.get(step);
        }
        catch (Throwable ex) {
            System.out.println("findStep(VWTrkStep step) throws exception - m_stepDataToUI is not null, step is not null");
            VWDebug.logException(new Exception(ex));
            return null;
        }
    }

    public void selectSteps(int[] stepIds) {
        try {
            if (stepIds != null && stepIds.length > 0) {
                IVWTrackerStepUI step = null;
                this.clearAllSelectedItems(false);
                for (int i = 0; i < stepIds.length; ++i) {
                    step = this.findStep(stepIds[i]);
                    if (step == null || !(step instanceof VWBaseStepUI)) continue;
                    if (i == 0) {
                        ((VWBaseStepUI)((Object)step)).setFocus(true);
                    }
                    ((VWBaseStepUI)((Object)step)).setSelect(true);
                }
                this.notifySelectListeners(true);
            }
        }
        catch (Throwable ex) {
            VWDebug.logException(new Exception(ex));
        }
    }

    public void itemStateChanged(ItemEvent e) {
        try {
            boolean bSelect;
            ItemSelectable itemSelectable = e.getItemSelectable();
            Object[] objects = itemSelectable.getSelectedObjects();
            boolean bl = bSelect = e.getStateChange() == 1;
            if (objects != null) {
                for (int i = 0; i < objects.length; ++i) {
                    if (objects[i] instanceof VWMapNode || objects[i] instanceof VWRouteDefinition) continue;
                    return;
                }
            }
            if (this.isSameSelection(objects)) {
                return;
            }
            this.clearAllSelectedItems(false);
            if (objects != null) {
                for (int index = 0; index < objects.length; ++index) {
                    Component component;
                    Object obj = objects[index];
                    if (obj instanceof VWMapNode) {
                        IVWTrackerStepUI step = null;
                        VWBaseStepUI baseStep = this.findStep((VWMapNode)obj);
                        if (baseStep instanceof IVWTrackerStepUI) {
                            step = (IVWTrackerStepUI)((Object)baseStep);
                        }
                        if (baseStep != null) {
                            baseStep.setSelect(true);
                            baseStep.setFocus(index == 0);
                            step.updateStepOccurrence();
                        }
                        component = (Component)((Object)step);
                    } else if (obj instanceof VWRouteDefinition) {
                        VWTrackerRouteUI route = null;
                        VWBaseRouteUI baseRoute = this.findRoute((VWRouteDefinition)obj);
                        if (baseRoute instanceof VWTrackerRouteUI) {
                            route = (VWTrackerRouteUI)baseRoute;
                        }
                        if (route != null) {
                            route.setSelect(true);
                            route.setFocus(index == 0);
                        }
                        component = route;
                    } else {
                        component = null;
                    }
                    if (component == null) continue;
                    this.repaint(component.getBounds());
                }
            }
        }
        catch (Throwable ex) {
            VWDebug.logException(new Exception(ex));
        }
    }

    public VWTrkMap getMapData() {
        return this.m_mapData;
    }

    public int getMapId() {
        if (this.m_map != null) {
            return this.m_map.getMapId();
        }
        return -1;
    }

    public String[] getParentMapNames() {
        Vector parentMaps;
        String[] parentMapNames = null;
        if (this.m_mapData != null && (parentMaps = this.m_mapData.getParentMaps()) != null && parentMaps.size() > 0) {
            parentMapNames = new String[parentMaps.size()];
            for (int i = 0; i < parentMaps.size(); ++i) {
                Object obj = parentMaps.elementAt(i);
                if (obj == null || !(obj instanceof VWTrkMap)) continue;
                parentMapNames[i] = ((VWTrkMap)obj).getMapName();
            }
            Object var2_2 = null;
        }
        return parentMapNames;
    }

    protected boolean isSameSelection(Object[] objects) {
        block13: {
            try {
                Object[] curSelection;
                int objCount = 0;
                int curCount = 0;
                if (objects != null) {
                    objCount = objects.length;
                }
                if ((curSelection = this.getSelectedObjects()) != null) {
                    curCount = curSelection.length;
                }
                if (objCount == curCount) {
                    int stepId = -1;
                    int routeId = -1;
                    if (objCount != 0) {
                        for (int i = 0; i < objCount; ++i) {
                            boolean bFound = false;
                            if (objects[i] instanceof VWMapNode) {
                                stepId = ((VWMapNode)objects[i]).getStepId();
                                routeId = -1;
                            } else if (objects[i] instanceof VWRouteDefinition) {
                                routeId = ((VWRouteDefinition)objects[i]).getRouteId();
                                stepId = -1;
                            } else {
                                return false;
                            }
                            for (int j = 1; j < curCount; ++j) {
                                Object obj = curSelection[j];
                                if (obj instanceof VWMapNode && stepId == ((VWMapNode)obj).getStepId()) {
                                    bFound = true;
                                    break;
                                }
                                if (!(obj instanceof VWRouteDefinition) || routeId != ((VWRouteDefinition)obj).getRouteId()) continue;
                                bFound = true;
                                break;
                            }
                            if (bFound) continue;
                            return false;
                        }
                    }
                    break block13;
                }
                return false;
            }
            catch (Throwable ex) {
                VWDebug.logException(new Exception(ex));
                return false;
            }
        }
        return true;
    }

    public void stateChanged(ChangeEvent e) {
        this.notifyChangeListeners();
    }

    public synchronized void addChangeListener(ChangeListener l) {
        this.m_changeListeners.addElement(l);
    }

    public synchronized void removeChangeListener(ChangeListener l) {
        this.m_changeListeners.removeElement(l);
    }

    protected void notifyChangeListeners() {
        for (int i = 0; i < this.m_changeListeners.size(); ++i) {
            ((ChangeListener)this.m_changeListeners.elementAt(i)).stateChanged(new ChangeEvent(this));
        }
    }

    public void mouseClicked(MouseEvent event) {
        this.requestFocus();
        super.mouseClicked(event);
    }

    public void mousePressed(MouseEvent event) {
        super.mousePressed(event);
        if (event.isPopupTrigger()) {
            this.showPopup(event);
        }
    }

    public void mouseReleased(MouseEvent event) {
        super.mouseReleased(event);
        if (event.isPopupTrigger()) {
            this.showPopup(event);
        }
    }

    private void showPopup(MouseEvent event) {
        try {
            IVWSelectWorkflowItem item;
            Object source = event.getSource();
            if (source instanceof VWTrackerWorkflowMapPane && (item = this.getItemAtLocation(event.getPoint())) instanceof IVWTrackerStepUI) {
                Vector selectedItems = this.getAllSelectedItems();
                if (selectedItems != null && selectedItems.size() > 1) {
                    return;
                }
                IVWTrackerStepUI step = (IVWTrackerStepUI)((Object)item);
                step.createPopup(this, event);
            }
        }
        catch (Throwable ex) {
            VWDebug.logException(new Exception(ex));
        }
    }

    public void propertyChange(VWPropertyChangeEvent event) {
        block14: {
            try {
                Object obj = event.getSource();
                if (!(obj instanceof IVWPropertyChangeSource)) break block14;
                IVWPropertyChangeSource source = (IVWPropertyChangeSource)obj;
                int type = event.getID();
                Vector items = null;
                switch (type) {
                    case 701: 
                    case 702: 
                    case 704: {
                        items = source.getItemsChanged();
                        if (items == null) {
                            return;
                        }
                        int stepId = 0;
                        for (int i = 0; i < items.size(); ++i) {
                            IVWTrackerStepUI step = null;
                            obj = items.elementAt(i);
                            if (obj == null) continue;
                            if (obj instanceof VWTrkStep) {
                                step = this.findStep((VWTrkStep)obj);
                            } else if (obj instanceof VWTrkStepOccurrence) {
                                stepId = ((VWTrkStepOccurrence)obj).getStepId();
                                step = this.findStep(stepId);
                            }
                            if (step == null) continue;
                            if (type == 701) {
                                step.updateLockStatusIcon();
                            } else {
                                step.updateStepOccurrence();
                            }
                            if (!(step instanceof VWBaseStepUI)) continue;
                            this.invalidStepRegion((VWBaseStepUI)((Object)step));
                        }
                        break;
                    }
                    case 705: {
                        Vector stepCollection = this.m_trackerDataModel.getStepCollection();
                        if (stepCollection == null || stepCollection.size() <= 0) break;
                        VWTrkStep step = null;
                        IVWTrackerStepUI stepUI = null;
                        for (int i = 0; i < stepCollection.size(); ++i) {
                            step = (VWTrkStep)stepCollection.elementAt(i);
                            if (step == null || step.getLastOccurrence() == null || (stepUI = this.findStep(step)) == null) continue;
                            stepUI.updateStepOccurrence();
                            if (!(stepUI instanceof VWBaseStepUI)) continue;
                            this.invalidStepRegion((VWBaseStepUI)((Object)stepUI));
                        }
                        break;
                    }
                }
            }
            catch (Throwable ex) {
                VWDebug.logException(new Exception(ex));
            }
        }
    }

    public void removeReferences() {
        Object obj;
        int i;
        if (this.m_steps != null) {
            for (i = 0; i < this.m_steps.size(); ++i) {
                obj = this.m_steps.elementAt(i);
                if (obj == null || !(obj instanceof VWBaseStepUI)) continue;
                ((VWBaseStepUI)obj).removeFocusListener(this);
                ((VWBaseStepUI)obj).removeReferences();
            }
            this.m_steps.removeAllElements();
            this.m_steps = null;
        }
        if (this.m_routes != null) {
            for (i = 0; i < this.m_routes.size(); ++i) {
                obj = this.m_routes.elementAt(i);
                if (obj == null || !(obj instanceof VWBaseRouteUI)) continue;
                ((VWBaseRouteUI)obj).removeFocusListener(this);
                ((VWBaseRouteUI)obj).removeReferences();
            }
            this.m_routes.removeAllElements();
            this.m_routes = null;
        }
        super.removeReferences();
        this.m_trackerDataModel = null;
        this.m_mapData = null;
        this.m_parentFrame = null;
        if (this.m_changeListeners != null) {
            this.m_changeListeners.removeAllElements();
            this.m_changeListeners = null;
        }
        if (this.m_popup != null) {
            this.m_popup.removeAll();
            this.m_popup = null;
        }
        if (this.m_stepDataToUI != null) {
            this.m_stepDataToUI.clear();
            this.m_stepDataToUI = null;
        }
        if (this.m_routeDataToUI != null) {
            this.m_routeDataToUI.clear();
            this.m_routeDataToUI = null;
        }
        this.removeAll();
    }

    public void activated() {
        super.activated();
        if (this.m_propertyChangeEvent != null) {
            this.propertyChange(this.m_propertyChangeEvent);
            this.m_propertyChangeEvent = null;
        }
    }
}

